% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge.xts}
\alias{merge.xts}
\alias{cbind.xts}
\title{Merge xts Objects}
\usage{
\method{merge}{xts}(
  ...,
  all = TRUE,
  fill = NA,
  suffixes = NULL,
  join = "outer",
  retside = TRUE,
  retclass = "xts",
  tzone = NULL,
  drop = NULL,
  check.names = NULL
)

\method{cbind}{xts}(..., all = TRUE, fill = NA, suffixes = NULL)
}
\arguments{
\item{\dots}{One or more xts objects, or objects coercible to class xts.}

\item{all}{A logical vector indicating merge type.}

\item{fill}{Values to be used for missing elements.}

\item{suffixes}{Suffix to be added to merged column names.}

\item{join}{Type of database join. One of 'outer', 'inner', 'left', or 'right'.}

\item{retside}{Which side of the merged object should be returned (2-case only)?}

\item{retclass}{Either a logical value indicating whether the result should
have a 'class' attribute, or the name of the desired class for the result.}

\item{tzone}{Time zone to use for the merged result.}

\item{drop}{Not currently used.}

\item{check.names}{Use \code{\link[=make.names]{make.names()}} to ensure column names are vaild \R
object names?}
}
\value{
A new xts object containing the appropriate elements of the
objects passed in to be merged.
}
\description{
Perform merge operations on xts objects by time index.
}
\details{
This xts method is compatible with \code{\link[=merge.zoo]{merge.zoo()}} but implemented almost
entirely in C-level code for efficiency.

The function can perform all common database join operations along the time
index by setting 'join' to one of the values below. Note that 'left' and
'right' are only implemented for two objects.
\itemize{
\item outer: full outer (all rows in all objects)
\item inner: only rows with common indexes in all objects
\item left: all rows in the first object, and rows from the second object that
have the same index as the first object
\item right: all rows in the second object, and rows from the first object that
have the same index as the second object
}

The above join types can also be accomplished by setting 'all' to one of the
values below.
\itemize{
\item outer: \code{all = TRUE} or \code{all = c(TRUE, TRUE)}
\item inner: \code{all = FALSE} or \code{all = c(FALSE, FALSE)}
\item left: \code{all = c(TRUE, FALSE)}
\item right: \code{all = c(FALSE, TRUE)}
}

The result will have the timezone of the leftmost argument if available. Use
the 'tzone' argument to override the default behavior.

When \code{retclass = NULL} the joined objects will be split and reassigned
silently back to the original environment they are called from. This is for
backward compatibility with zoo, but unused by xts. When \code{retclass = FALSE}
the object will be stripped of its class attribute. This is for internal use.

See the examples in order to join using an 'all' argument that is the same
arguments to join, like you can do with \code{merge.zoo()}.
}
\note{
This is a highly optimized merge, specifically designed for ordered
data. The only supported merging is based on the underlying time index.
}
\examples{

(x <- xts(4:10, Sys.Date()+4:10))
(y <- xts(1:6, Sys.Date()+1:6))

merge(x,y)
merge(x,y, join='inner')
merge(x,y, join='left')
merge(x,y, join='right')

merge.zoo(zoo(x),zoo(y),zoo(x), all=c(TRUE, FALSE, TRUE))
merge(merge(x,x),y,join='left')[,c(1,3,2)]

# zero-width objects (only index values) can be used
xi <- xts( , index(x))
merge(y, xi)

}
\references{
Merge Join Discussion:
\url{https://blogs.msdn.microsoft.com/craigfr/2006/08/03/merge-join/}
}
\author{
Jeffrey A. Ryan
}
\keyword{manip}
\keyword{utilities}
