% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cwres.wres.vs.idv.R
\name{cwres.wres.vs.idv}
\alias{cwres.wres.vs.idv}
\title{Weighted residuals (WRES) and conditional WRES (CWRES) plotted against the
independent variable (IDV)}
\usage{
cwres.wres.vs.idv(
  object,
  ylb = "Residuals",
  abline = c(0, 0),
  smooth = TRUE,
  scales = list(),
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}

\item{abline}{Vector of arguments to the \code{\link[lattice]{panel.abline}}
function. No abline is drawn if \code{NULL}.}

\item{smooth}{A \code{NULL} value indicates that no superposed line should
be added to the graph. If \code{TRUE} then a smooth of the data will be
superimposed.}

\item{scales}{scales is passed to  \code{\link{xpose.plot.default}}.}

\item{\dots}{Other arguments passed to \code{\link{xpose.plot.default}}.}
}
\value{
A compound xyplot.
}
\description{
A graphical comparison  between the WRES and CWRES as plotted against the
independent variable. Conditional weighted residuals (CWRES) require 
some extra steps to calculate. Either add \code{CWRES} to your NONMEM 
table files or compute them using the information proveded in 
\code{\link{compute.cwres}}. A wide array of extra options controlling 
xyplots are available. See \code{\link{xpose.plot.default}} and 
\code{\link{xpose.panel.default}} for details.
}
\examples{
cwres.wres.vs.idv(simpraz.xpdb)
}
\seealso{
\code{\link{xpose.plot.default}},
\code{\link{xpose.panel.default}}, \code{\link[lattice]{xyplot}},
\code{\link{xpose.prefs-class}}, \code{\link{xpose.data-class}},
\code{\link{compute.cwres}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.pred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{gof}()},
\code{\link{ind.plots}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}
}
\author{
Niclas Jonsson & Andrew Hooker
}
\concept{specific functions}
