% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose_data_nlmixr.R
\name{xpose_data_nlmixr}
\alias{xpose_data_nlmixr}
\title{Import nlmixr output into xpose}
\usage{
xpose_data_nlmixr(
  obj = NULL,
  pred = NULL,
  wres = NULL,
  gg_theme = theme_readable(),
  xp_theme = theme_xp_default(),
  quiet,
  skip = NULL,
  ...
)
}
\arguments{
\item{obj}{nlmixr fit object to be evaluated.}

\item{pred}{Name of the population prediction variable to use for
plotting. If unspecified, it will choose either "NPDE",
"CWRES", and "RES" (in that order) if the column exists in the
data.}

\item{wres}{Name of the weighted residual variable to use for
plotting. If unspecified, it will choose either "NPDE",
"CWRES", and "RES" (in that order) if the column exists in the
data.}

\item{gg_theme}{A ggplot2 theme object.}

\item{xp_theme}{An xpose theme or vector of modifications to the
xpose theme (eg. \code{c(point_color = 'red', line_linetype =
'dashed')}).}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the
console.}

\item{skip}{Character vector be used to skip the import/generation
of: 'data', 'files', 'summary' or any combination of the three.}

\item{...}{Additional arguments to be passed to the
\code{\link[readr]{read_delim}} functions.}
}
\value{
An \code{\link[xpose]{xpose_data}} object suitable for use in 'xpose'.
}
\description{
Convert 'nlmixr' model output into an 'xpose' database.
}
\examples{
xpdb <- xpose_data_nlmixr(obj = theo_sd_fit)

}
