% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/coincidence.R
\name{est.coi}
\alias{est.coi}
\title{Estimate the coincidence function}
\usage{
est.coi(cross, chr, pos, window = 0, fill.method = c("imp", "argmax"),
  error.prob = 0.0000000001, map.function = c("haldane", "kosambi", "c-f",
  "morgan"))
}
\arguments{
\item{cross}{Cross object; must be a backcross.  See
\code{\link[qtl]{read.cross}} for format details.}

\item{chr}{Chromosome to consider (only one is allowed).  If missing, the
first chromosome is considered.}

\item{pos}{If provided, these are used as the marker positions.  (This could
be useful if you want to do things with respect to physical distance.)}

\item{window}{Window size used to smooth the estimates.}

\item{fill.method}{Method used to impute missing data.}

\item{error.prob}{Genotyping error probability used in imputation of missing
data.}

\item{map.function}{Map function used in imputation of missing data.}
}
\value{
A data.frame containing the distance between intervals and the
corresponding estimate of the coincidence.  There are actually two columns
of estimates of the coincidence.  In the first estimate, we take a running
mean of each of the numerator and denominator and then divide.  In the
second estimate, we first take a ratio and then take a running mean.
}
\description{
Estimate the coincidence function from backcross data.
}
\details{
The coincidence function is the probability of a recombination event in both
of two intervals, divided by the product of the two recombination fractions.
We estimate this as a function of the distance between the two intervals.

Note that we first call \code{\link[qtl]{fill.geno}} to impute any missing
genotype data.
}
\examples{
map1 <- sim.map(103, n.mar=104, anchor=TRUE, include.x=FALSE, eq=TRUE)
x <- sim.cross(map1, n.ind=2000, m=6, type="bc")

out <- est.coi(x, window=5)
plot(coi1 ~ d, data=out, type="l", lwd=2, col="blue")
lines(coi2 ~ d, data=out, lwd=2, col="green")
lines(gammacoi(7), lwd=2, col="red", lty=2)
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\references{
McPeek, M. S. and Speed, T. P. (1995) Modeling interference in
genetic recombination.  \emph{Genetics} \bold{139}, 1031--1044.
}
\seealso{
\code{\link{gammacoi}}, \code{\link{stahlcoi}}, \code{\link{kfunc}}
}
\keyword{models}

