% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_labels.R
\name{match_labels}
\alias{match_labels}
\title{Reorder the label matrix}
\usage{
match_labels(y, rows, cols = NULL)
}
\arguments{
\item{y}{a matrix representing the label matrix.}

\item{rows}{a character vector with the labels for the rows or a matrix
with rownames that will be used as labels.}

\item{cols}{a character vector with the labels for the cols or a matrix
with colnames that will be used as labels. If \code{NULL}, \code{rows} will be
used for both row and column labels.}
}
\value{
a matrix with the rows and columns reordered.
}
\description{
Reorders the label matrix based on the labels of the kernel matrices.
In case there are no labels, the original label matrix is returned,
but with the labels in \code{rows} and \code{cols} as rownames and
column names respectively.
}
\examples{
mat <- matrix(1:6, ncol = 2,
              dimnames = list(c("b", "a", "d"),
                              c("ca", "cb"))
             )

match_labels(mat, c("a","b", "d"), c("ca","cb"))

#Using matrices
data(drugtarget)
out <- match_labels(drugTargetInteraction, targetSim, drugSim)

}
