% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xml_attr.R
\name{xml_attr}
\alias{xml_attr}
\alias{xml_attrs}
\alias{xml_has_attr}
\title{Retrieve an attribute.}
\usage{
xml_attr(x, attr, ns = character(), default = NA_character_)

xml_has_attr(x, attr, ns = character())

xml_attrs(x, ns = character())
}
\arguments{
\item{x}{A document, node, or node set.}

\item{attr}{Name of attribute to extract.}

\item{ns}{Optionally, a named vector giving prefix-url pairs, as produced
by \code{\link{xml_ns}}. If provided, all names will be explicitly
qualified with the ns prefix, i.e. if the element \code{bar} is defined
in namespace \code{foo}, it will be called \code{foo:bar}. (And
similarly for atttributes). Default namespaces must be given an explicit
name.}

\item{default}{Default value to use when attribute is not present.}
}
\value{
\code{xml_attr()} returns a character vector. \code{NA} is used
 to represent of attributes that aren't defined.

 \code{xml_has_attr()} returns a logical vector.

 \code{xml_attrs()} returns a named character vector if \code{x} x is single
 node, or a list of character vectors if given a nodeset
}
\description{
\code{xml_attrs()} retrieves all attributes values as a named character
vector. \code{xml_attr()} retrieves the value of single attribute. If the
attribute doesn't exist, it will return \code{default}, which defaults to
\code{NA}. \code{xml_has_attr()} tests if an attribute is present.
}
\examples{
x <- read_xml("<root id='1'><child id ='a' /><child id='b' d='b'/></root>")
xml_attr(x, "id")
xml_attr(x, "apple")
xml_attrs(x)

kids <- xml_children(x)
kids
xml_attr(kids, "id")
xml_has_attr(kids, "id")
xml_attrs(kids)

# Missing attributes give missing values
xml_attr(xml_children(x), "d")
xml_has_attr(xml_children(x), "d")

# If the document has a namespace, use the ns argument and
# qualified attribute names
x <- read_xml('
 <root xmlns:b="http://bar.com" xmlns:f="http://foo.com">
   <doc b:id="b" f:id="f" id="" />
 </root>
')
doc <- xml_children(x)[[1]]
ns <- xml_ns(x)

xml_attrs(doc)
xml_attrs(doc, ns)

# If you don't supply a ns spec, you get the first matching attribute
xml_attr(doc, "id")
xml_attr(doc, "b:id", ns)
xml_attr(doc, "id", ns)
}

