% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAccountDetail.R
\name{getAccountDetail}
\alias{getAccountDetail}
\title{Get an overview of an account on the Stellar ledger.}
\usage{
getAccountDetail(pk, data = NA, domain = "public")
}
\arguments{
\item{pk}{character - your Stellar account address (also known as a public key.)}

\item{data}{character - if the Stellar account has data key-value pairs assigned to it, pass the key name to get the value.
The internal request builder will attempt to parse the key to ASCII if it contains any non-ASCII characters.}

\item{domain}{character - signalling to query the testnet or public network. Can be either "testnet" or "public".}
}
\value{
list or Account class.
}
\description{
Query the accounts endpoint, specifying no extra resources. Converts the JSON response to a list.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/accounts-single.html
}
\examples{
getAccountDetail("GCO2IP3MJNUOKS4PUDI4C7LGGMQDJGXG3COYX3WSB4HHNAHKYV5YL3VC")
}
