## Emilio Torres Manzanera
## University of Oviedo
## Time-stamp: <2018-05-23 17:40 emilio on emilio-despacho>
## ============================================================




##' It draws fuzzy rectangles.
##'
##' This function draws fuzzy rectangles.
##'
##'   It plots rectangles. The following aesthetics are required:
##' \enumerate{
##'   \item xmin
##'   \item ymin
##'   \item xmax
##'   \item ymax
##' }
##' Additionally, you can use the aesthetics of \code{\link[ggplot2]{geom_path}} and \code{\link[ggplot2]{geom_rect}}.
##' @title Draw fuzzy rectangles
##' @param mapping Mapping between variables and aesthetics generated by \code{\link[ggplot2]{aes}}. See Details.
##' @param data Dataset used in this layer.
##' @param ... Optional arguments.
##' @return A layer.
##' @seealso   \code{\link[ggplot2]{aes}},  \code{\link[ggplot2]{geom_path}}
##' @keywords manip
##' @import ggplot2
##' @export
##' @examples
##' volunteers <- data.frame(year=c(2007:2011),
##'                         number=c(56470, 56998,59686, 61783, 64251))
##' p <- ggplot() + xkcdrect(aes(xmin = year,
##'                              xmax= year +0.3,
##'                              ymin=number,
##'                              ymax = number + 3600),
##'                          volunteers,
##'                          fill="red", colour="black")
##' p
xkcdrect <- function(mapping, data, ...) {

    requiredaesthetics <-  c("xmin","ymin",
                             "xmax","ymax")

    rect1 <-  with(data,geom_rect(mapping, data, ...))

    defaultmapdat <- createdefaultmappinganddata(mapping, data, requiredaesthetics)
    data <-defaultmapdat$data
    mapping <- defaultmapdat$mapping


    xrange <- range(min(data$xmin, data$xmax), max(data$xmin, data$xmax))
    yrange <- range(min(data$ymin, data$ymax), max(data$ymin, data$ymax))
    borderxjitteramount <- diff(xrange)/100
    borderyjitteramount <- diff(yrange)/100

    bordercolour <- "white"
    bordersize <- 3

    argList <- list(...)
    if( "colour" %in% names(argList) ) bordercolour <- argList[["colour"]]
    if( "color" %in% names(argList) ) bordercolour <- argList[["color"]]
    if( "size" %in% names(argList) ) bordersize <- argList[["size"]]
    if( "xjitteramount" %in% names(argList) ) borderxjitteramount <- argList[["xjitteramount"]]
    if( "yjitteramount" %in% names(argList) ) borderyjitteramount <- argList[["yjitteramount"]]


    ## ## To avoid  Notes when R CMD check, use a with
    ## mappu <- with(data, mappingjoin(aes(x=xmin,y=ymax, xend=xmax, yend=ymax), mapping))
    ## mappr <- with(data, mappingjoin(aes(xbegin=xmax,ybegin=ymin, xend=xmax, yend=ymax), mapping))
    ## mappl <- with(data, mappingjoin(aes(xbegin=xmin,ybegin=ymin, xend=xmin, yend=ymax), mapping))
    ## mappb <- with(data, mappingjoin(aes(xbegin=xmin,ybegin=ymin, xend=xmax, yend=ymin), mapping))


    mappu <- with(data, aes(x=xmin,y=ymax, xend=xmax, yend=ymax))
    mappr <- with(data, aes(x=xmax,y=ymin, xend=xmax, yend=ymax))
    mappl <- with(data, aes(x=xmin,y=ymin, xend=xmin, yend=ymax))
    mappb <- with(data, aes(x=xmin,y=ymin, xend=xmax, yend=ymin))
    
    upperline <- xkcdline(mappu,
                          data, colour=bordercolour,
                          yjitteramount=borderyjitteramount, mask = FALSE, size=bordersize, ...)
    rightline <-  xkcdline(mappr,
                          data, colour=bordercolour,
                          xjitteramount=borderxjitteramount, mask = FALSE, size=bordersize, ...)
    leftline <-  xkcdline(mappl,
                          data, colour=bordercolour,
                          xjitteramount=borderxjitteramount, mask = FALSE, size=bordersize, ...)
    bottomline <-  xkcdline(mappb,
                          data, colour=bordercolour,
                          yjitteramount=borderyjitteramount, mask = FALSE, size=bordersize, ...)


    ## upperline <- xkcdline(aes(x=xmin,y=ymax,xend=xmax,yend=ymax),
    ##                       data, colour=bordercolour,
    ##                       yjitteramount=borderyjitteramount, mask = FALSE, size=bordersize, ...)

    ## rightline <-  xkcdline(aes(x=xmax,y=ymin,xend=xmax,yend=ymax),
    ##                        data, colour=bordercolour,
    ##                        xjitteramount=borderxjitteramount, mask = FALSE, size=bordersize, ...)

    ## leftline <-  xkcdline(aes(x=xmin,y=ymin,xend=xmin,yend=ymax),
    ##                       data, colour=bordercolour,
    ##                       xjitteramount=borderxjitteramount, mask = FALSE, size=bordersize, ...)

    ## bottomline <-  xkcdline(aes(x=xmin,y=ymin,xend=xmax,yend=ymin),
    ##                         data, colour=bordercolour,
    ##                         yjitteramount=borderyjitteramount, mask = FALSE, size=bordersize, ...)


    list(rect1, upperline , rightline, leftline, bottomline)
}
