% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGpInitGene.R
\name{xegaGpInitGene}
\alias{xegaGpInitGene}
\title{Generates a gene as a random derivation tree.}
\usage{
xegaGpInitGene(lF)
}
\arguments{
\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
Derivation tree.
}
\description{
For a given grammar, \code{xegaGpInitGene()} 
             generates a gene as a random derivation tree
             with a depth-bound.
}
\details{
In the derivation tree representation of 
         package \code{xegaGp}, \emph{gene} is a list with 
         \enumerate{
         \item \code{$evaluated}: Boolean: TRUE if the fitness is known.
         \item \code{$fit}:       The fitness of the genotype of 
                                 \code{$gene1}         
         \item \code{$gene1}:     a derivation tree.
         }

         This representation makes implementation of several 
         code optimizations and generalizations easier.

         The algorithm for generating a complete derivation tree 
         with a depth-bound
         is imported from package \code{xegaDerivationTrees}.
}
\examples{
gene<-xegaGpInitGene(lFxegaGpGene)

}
\concept{Initialization}
