% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaDecode.R
\name{xegaGaGeneMap}
\alias{xegaGaGeneMap}
\title{Map the bit strings of a binary gene to parameters in an interval.}
\usage{
xegaGaGeneMap(gene, penv)
}
\arguments{
\item{gene}{A binary gene (the genotype).}

\item{penv}{A problem environment.}
}
\value{
The decoded gene (the phenotype).
}
\description{
\code{xegaGaGenemap} maps the bit strings of a binary string 
             to parameters in an interval.
             Bit vectors are mapped into equispaced numbers in the interval.
             Examples: Optimization of problems with real-valued 
                       parameter vectors.
}
\examples{
gene<-xegaGaInitGene(lFxegaGaGene)
xegaGaGeneMap(gene$gene1, lFxegaGaGene$penv)

}
\seealso{
Other Decoder: 
\code{\link{xegaGaDecodeGene}()},
\code{\link{xegaGaGeneMapGray}()},
\code{\link{xegaGaGeneMapIdentity}()},
\code{\link{xegaGaGeneMapPerm}()}
}
\concept{Decoder}
