% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{xQTLquery_sampleByTissue}
\alias{xQTLquery_sampleByTissue}
\title{Query sample's details with tissue name}
\usage{
xQTLquery_sampleByTissue(
  tissueSiteDetail = "Liver",
  dataType = "RNASEQ",
  recordPerChunk = 200,
  pathologyNotesCategories = FALSE
)
}
\arguments{
\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{dataType}{A character string. Options: "RNASEQ" (default), "WGS", "WES", "OMNI".}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 200).}

\item{pathologyNotesCategories}{Default: pathologyNotes info is ignored.}
}
\value{
returen a data.table object of samples' information
}
\description{
Query sample's details with tissue name
}
\examples{
sampleInfo <- xQTLquery_sampleByTissue("Brain - Amygdala" )
sampleInfo <- xQTLquery_sampleByTissue(tissueSiteDetail="Liver", pathologyNotesCategories=TRUE)
}
