% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_sc}
\alias{xQTLdownload_sc}
\title{download all sc-eQTL associations}
\usage{
xQTLdownload_sc(
  gene = "BIN3",
  geneType = "geneSymbol",
  cell_type = "Astrocytes",
  cell_state = "",
  qtl_type = "Cell-type eQTL",
  study_name = "Bryois2022NN"
)
}
\arguments{
\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported).}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "geneSymbol".}

\item{cell_type}{(character)cell types supported in the list of study_info from 'xQTLquery_scInfo'}

\item{cell_state}{(character)cell states supported in the list of study_info from 'xQTLquery_scInfo'}

\item{qtl_type}{(character)QTL types supported in the list of study_info from 'xQTLquery_scInfo'}

\item{study_name}{(character)study name supported in the list of study_info from 'xQTLquery_scInfo'}
}
\value{
A data.table object
}
\description{
download all sc-eQTL associations
}
\examples{
\donttest{
 xQTLdownload_sc(gene="TP53", cell_type = "B cell",
                 qtl_type="Cell-type eQTL", study_name = "Resztak2022biorxiv")
}
}
