% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hf.snps.meth.R
\name{hf.snps.meth}
\alias{hf.snps.meth}
\title{Parameters calculation for adjustment of W-test for gene-methylation interaction analysis}
\usage{
hf.snps.meth(B = 400, geno, meth, y, geno.pos, meth.pos, window.size,
  n.sample = nrow(geno), n.pair = 1000)
}
\arguments{
\item{B}{a numeric number specify the number of replicates. Default is 400.}

\item{geno}{a data frame or matrix contains genotypes in the columns. Genotypes should be coded as (0, 1, 2) or (0, 1). SNP names should be stored at column names of the data.}

\item{meth}{a data frame or matrix contains methylation data in the columns. Methylation data should be recoded as (0, 1, 2) or (0, 1). Names of CpG sites should be stored at column names of the data.}

\item{y}{a numeric vector composed of 0 or 1; or a factor variable with two levels.}

\item{geno.pos}{a data frame contains SNP names and positions in two columns.}

\item{meth.pos}{a data frame contains CpG names and positions in two columns.}

\item{window.size}{a numeric number specifies the size of genome distance. Interaction effects of the SNPs and CpG sites located within the size of genome distance will be evaluated exhaustively.}

\item{n.sample}{a numeric number specify the number of samples to be involved for estimating parameters. Default is the total number of samples in the data.}

\item{n.pair}{a numeric value, the number of SNP-CpG pairs to use in bootstrapping. Default is the minumn value of total number of pairs within a genome distance and 1000.}
}
\value{
a set of parameters indexed by \emph{k}, obtained automatically. For main effect, \emph{k} is the number of levels of a predictor variable. For pairwise interactions, \emph{k} is the number of categorical combinations of a pair.
}
\description{
Function to estimate parameters (\emph{h} and \emph{f}) for \code{W-test}
}
\examples{
data(SNP_pos)
data(CpG_pos)
data(genotype)
data(methylation)
data(phenotype2)

## Step 1. HF Calculation.
# Please note that parameter B is recommended to be greater than 400.
hf.pair <- hf.snps.meth(B = 80, geno = genotype, meth = methylation, y = phenotype2,
                        geno.pos = SNP_pos, meth.pos = CpG_pos, window.size = 1000)

}
\references{
Maggie Haitian Wang, Rui Sun, Junfeng Guo, Haoyi Weng, Jack Lee, Inchi Hu, Pak Sham and Benny C.Y. Zee (2016). A fast and powerful W-test for pairwise epistasis testing. Nucleic Acids Research.doi:10.1093/nar/gkw347.
}
\author{
Rui Sun, Maggie Haitian Wang
}
