% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_wrapr_tests.R
\name{run_wrapr_tests}
\alias{run_wrapr_tests}
\title{Run wrapr package tests.}
\usage{
run_wrapr_tests(..., verbose = TRUE, package_test_dirs = "unit_tests",
  test_dirs = character(0), stop_on_issue = TRUE,
  stop_if_no_tests = TRUE, require_RUnit_attached = FALSE,
  require_pkg_attached = TRUE, rngKind = "Mersenne-Twister",
  rngNormalKind = "Inversion")
}
\arguments{
\item{...}{not used, force later arguments to bind by name.}

\item{verbose}{logical, if TRUE print more.}

\item{package_test_dirs}{directory names to look for in the installed package.}

\item{test_dirs}{paths to look for tests in.}

\item{stop_on_issue}{logical, if TRUE stop after errors or failures.}

\item{stop_if_no_tests}{logical, if TRUE stop if no tests were found.}

\item{require_RUnit_attached}{logical, if TRUE require RUnit be attached before testing.}

\item{require_pkg_attached}{logical, if TRUE require pkg be attached before testing.}

\item{rngKind}{pseudo-random number generator method name.}

\item{rngNormalKind}{pseudo-random normal generator method name.}
}
\value{
RUnit test results (invisible).
}
\description{
For all files with names of the form "^test_.+\\.R$" in the package directory unit_tests
run all functions with names of the form "^test_.+$" as RUnit tests.
Attaches RUnit and pkg, requires RUnit.
Stops on error.
}
\details{
Based on \url{https://github.com/RcppCore/Rcpp/blob/master/tests/doRUnit.R}.  This
version is GPL-3, works derived from it must be distributed GPL-3.
}
