% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSdrf.R
\name{readSdrf}
\alias{readSdrf}
\title{Read proteomics meta-data as sdrf file}
\usage{
readSdrf(
  fi,
  chCol = "auto",
  urlPrefix = "github",
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{fi}{(character) main input; may be full path or url to the file with meta-annotation. If a short project-name is given,
it will be searched based at the location of \code{urlPrefix}}

\item{chCol}{(character, length=1) optional checking of column-names}

\item{urlPrefix}{(character, length=1) prefix to add to search when no complete path or url is given on \code{fi}, defaults to proteomics-metadata-standard on github}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of messages produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns the content of sdrf-file as data.frame (or \code{NULL} if the corresponding file was not found)
}
\description{
This function allows reading proteomics meta-data from sdrf file, as they are provided on https://github.com/bigbio/proteomics-metadata-standard.
A data.frame containing all annotation data will be returned. To stay conform with the (non-obligatory) recommendations, columnnames are shown as lower caps.
}
\details{
The packages utils and wrMisc must be installed.
Please note that reading sdrf files (if not provided as local copy) will take a few seconds, depending on the responsiveness of github.
}
\examples{
## This may take a few sconds...
sdrf001819 <- readSdrf("PXD001819")
str(sdrf001819)


}
\seealso{
in \code{\link[utils]{read.table}}
}
