% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMaxQuantFile.R
\name{readMaxQuantFile}
\alias{readMaxQuantFile}
\title{Read csv or txt files exported from MS-Angel and Proline}
\usage{
readMaxQuantFile(
  path,
  fileName = "proteinGroups.txt",
  normalizeMeth = "median",
  quantCol = "LFQ.intensity",
  contamCol = "Potential.contaminant",
  uniqPepPat = "Razor...unique.peptides",
  refLi = NULL,
  extrColNames = c("Majority.protein.IDs", "Fasta.headers", "Number.of.proteins"),
  specPref = c(conta = "conta|CON_|LYSC_CHICK", mainSpecies = "OS=Homo sapiens"),
  tit = NULL,
  wex = 1.6,
  separateAnnot = TRUE,
  plotGraph = TRUE,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{path}{(character) path of file to be read}

\item{fileName}{(character) name of file to be read (default 'proteinGroups.txt' as typically generated by MaxQuant in txt folder)}

\item{normalizeMeth}{(character) normalization method (will be sent to  \code{\link[wrMisc]{normalizeThis}})}

\item{quantCol}{(character or integer) exact col-names, or if length=1 content of \code{quantCol} will be used as pattern to search among column-names for $quant using \code{grep}}

\item{contamCol}{(character or integer, length=1) which columns should be used for contaminants marked by ProteomeDiscoverer}

\item{uniqPepPat}{(character, length=1) pattern to search for columns with unique (razor) peptides using \code{grep}, default set to read unique razor-peptides}

\item{refLi}{(character or integer) custom specify which line of data is main species, if character (eg 'mainSpe'), the column 'SpecType' in $annot will be searched for exact match of the (single) term given}

\item{extrColNames}{(character) column names to be read (1: prefix for LFQ quantitation, default 'LFQ.intensity'; 2: column name for protein-IDs, default 'Majority.protein.IDs'; 3: column names of fasta-headers, default 'Fasta.headers', 4: column name for number of protein IDs matching, default 'Number.of.proteins')}

\item{specPref}{(character) prefix to identifiers allowing to separate i) recognize contamination database, ii) species of main identifications and iii) spike-in species}

\item{tit}{(character) custom title to plot}

\item{wex}{(numeric)  relative expansion factor of the violin in plot}

\item{separateAnnot}{(logical) if \code{TRUE} output will be organized as list with \code{$annot}, \code{$abund} for initial/raw abundance values and \code{$quant} with final normalized quantitations}

\item{plotGraph}{(logical) optional plot vioplot of initial and normalized data (using \code{normalizeMeth}); alternatively the argument may contain numeric details that will be passed to \code{layout} when plotting}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message produced}
}
\value{
list with \code{$annot}, \code{$raw} for initial abundance values and \code{$quant} with final normalized quantitations, or returns data.frame with annot and quant if \code{separateAnnot=FALSE}
}
\description{
Quantification results form \href{https://www.maxquant.org/}{MaxQuant} can be read using this function and relevant information extracted. 
The final output is a list containing 3 elements: \code{$annot}, \code{$abund} and optional \code{$quant}, or returns data.frame with entire content of file if \code{separateAnnot=FALSE}.
This function has been developed using MaxQuant version 1.6.10.x, the format of resulting file 'proteinGroups.txt' is typically well conserved.
}
\examples{
path1 <- system.file("extdata",package="wrProteo")
# Here we'll load a short/trimmed example file (thus not MaxQuant default name) 
fiNa <- "proteinGroupsMaxQuantUps1.txt"
specPref1 <- c(conta="conta|CON_|LYSC_CHICK", mainSpecies="YEAST",spike="HUMAN_UPS")
dataMQ <- readMaxQuantFile(path1, file=fiNa, specPref=specPref1)
summary(dataMQ$quant)
matrixNAinspect(dataMQ$quant, gr=gl(3,3)) 
}
\seealso{
\code{\link[utils]{read.table}}, \code{\link[wrMisc]{normalizeThis}}) , \code{\link{readProlineFile}}
}
