% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colMedSds.R
\name{colMedSds}
\alias{colMedSds}
\title{Standard Error Of Median For Each Column By Bootstrap}
\usage{
colMedSds(dat, nBoot = 99, silent = FALSE, debug = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{(numeric) matix}

\item{nBoot}{(integer, length=1) number if iterations}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a (numeric) vector with estimated standard errors
}
\description{
Determine standard error (sd) of median by bootstraping for multiple sets of data (rows in input matrix 'dat').
Note: The package \href{https://CRAN.R-project.org/package=boot}{boot} must be installed from CRAN.
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200) +rep(1:10,20)), ncol=10)
colMedSds(dat1) 
}
\seealso{
\code{\link[boot]{boot}}
}
