% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpGraySca.R
\name{transpGraySca}
\alias{transpGraySca}
\title{Make single vector gray-gradient}
\usage{
transpGraySca(startGray = 0.2, endGrey = 0.8, nSteps = 5, transp = 0.3)
}
\arguments{
\item{startGray}{(numeric) gray shade at start}

\item{endGrey}{(numeric)  gray shade at end}

\item{nSteps}{(integer) number of levels}

\item{transp}{(numeric) transparency alpha}
}
\value{
character vector (of same length as x) with color encoding
}
\description{
This function helps making gray-gradients.
Note : The resulting color gradient does not seem linear to the human eye, you may try \code{\link[grDevices]{gray.colors}} instead
}
\examples{
layout(1:2)
col1 <- transpGraySca(0.8,0.3,7,0.9) 
pie(rep(1,length(col1)), col=col1, main="from transpGraySca")
col2 <- gray.colors(7,0.9,0.3,alph=0.9)
pie(rep(1,length(col2)), col=col2, main="from gray.colors")
}
\seealso{
\code{\link[grDevices]{gray.colors}}
}
