% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowGrpNA.R
\name{rowGrpNA}
\alias{rowGrpNA}
\title{Count number of NAs per row and group of columns}
\usage{
rowGrpNA(mat, grp)
}
\arguments{
\item{mat}{(matrix of data.frame) data to count the number of \code{NA}s}

\item{grp}{(character or factor) defining which columns should be grouped (considered as replicates)}
}
\value{
matrix with number of \code{NA}s per group
}
\description{
This functions allows easy counting the number of NAs per row in data organized in multiple sub-groups as columns.
}
\examples{
mat2 <- c(22.2, 22.5, 22.2, 22.2, 21.5, 22.0, 22.1, 21.7, 21.5, 22, 22.2, 22.7,
   NA, NA, NA, NA, NA, NA, NA, 21.2,   NA, NA, NA, NA,
   NA, 22.6, 23.2, 23.2,  22.4, 22.8, 22.8, NA,  23.3, 23.2, NA, 23.7,
   NA, 23.0, 23.1, 23.0,  23.2, 23.2, NA, 23.3,  NA, NA, 23.3, 23.8)
mat2 <- matrix(mat2, ncol=12, byrow=TRUE)
gr4 <- gl(3, 4, labels=LETTERS[1:3])
# overal number of NAs per row
rowSums(is.na(mat2)) 
# number of NAs per row and group
rowGrpNA(mat2, gr4)
}
\seealso{
\code{\link{rowGrpMeans}}, \code{\link{rowSds}}, \code{\link[base]{colSums}}
}
