% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_trans.R
\name{anlz_trans}
\alias{anlz_trans}
\title{Transform response variable}
\usage{
anlz_trans(moddat, trans = c("log10", "ident"))
}
\arguments{
\item{moddat}{input raw data, one station and paramater}

\item{trans}{chr string indicating desired type of transformation, one of \code{log10} or \code{ident} (no transformation)}
}
\value{
\code{moddat} with the \code{value} column transformed as indicated
}
\description{
Transform response variable prior to fitting GAM
}
\examples{
library(dplyr)
tomod <- rawdat \%>\% 
  filter(station \%in\% 34) \%>\% 
  filter(param \%in\% 'chl')
anlz_trans(tomod, trans = 'log10')
}
\seealso{
Other analyze: 
\code{\link{anlz_sumtrndseason}()},
\code{\link{anlz_trndseason}()}
}
\concept{analyze}
