% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_mettrndseason.R
\name{show_mettrndseason}
\alias{show_mettrndseason}
\title{Plot seasonal metrics and rates of change}
\usage{
show_mettrndseason(
  mod,
  metfun = mean,
  doystr = 1,
  doyend = 364,
  justify = c("center", "left", "right"),
  win = 5,
  nsim = 10000,
  useave = FALSE,
  yromit = NULL,
  ylab,
  width = 0.9,
  size = 3,
  nms = NULL,
  cols = NULL,
  cmbn = F,
  base_size = 11,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{metfun}{function input for metric to calculate, e.g., \code{mean}, \code{var}, \code{max}, etc}

\item{doystr}{numeric indicating start Julian day for extracting averages}

\item{doyend}{numeric indicating ending Julian day for extracting averages}

\item{justify}{chr string indicating the justification for the trend window}

\item{win}{numeric indicating number of years to use for the trend window, see details}

\item{nsim}{numeric indicating number of random draws for simulating uncertainty}

\item{useave}{logical indicating if \code{anlz_avgseason} is used for the seasonal metric calculation}

\item{yromit}{optional numeric vector for years to omit from the plot, see details}

\item{ylab}{chr string for y-axis label}

\item{width}{numeric for width of error bars}

\item{size}{numeric for point size}

\item{nms}{optional character vector for trend names, see details}

\item{cols}{optional character vector for point colors, see details}

\item{cmbn}{logical indicating if the no trend and on estimate colors should be combined, see details}

\item{base_size}{numeric indicating base font size, passed to \code{\link[ggplot2]{theme_bw}}}

\item{xlim}{optional numeric vector of length two for x-axis limits}

\item{ylim}{optional numeric vector of length two for y-axis limits}

\item{...}{additional arguments passed to \code{metfun}, e.g., \code{na.rm = TRUE)}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot seasonal metrics and rates of change
}
\details{
The plot is the same as that returned by \code{\link{show_metseason}} with the addition of points for the seasonal metrics colored by the trends estimated from \code{\link{anlz_trndseason}} for the specified window and justification.  

Four colors are used to define increasing, decreasing, no trend, or no estimate (i.e., too few points for the window).  The names and the colors can be changed using the \code{nms} and \code{cols} arguments, respectively.  The \code{cmbn} argument can be used to combine the no trend and no estimate colors into one color and label. Although this may be desired for aesthetic reasons, the colors and labels may be misleading with the default names since no trend is shown for points where no estimates were made.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')
show_mettrndseason(mod, metfun = mean, doystr = 90, doyend = 180, justify = 'center', 
  win = 4, ylab = 'Chlorophyll-a (ug/L)')
}
\concept{show}
