% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ITSA.R
\name{create_ITSA}
\alias{create_ITSA}
\title{Estimate an effect of intervention on every Viva Insights metric in input
file by applying single-group Interrupted Time-Series Analysis (ITSA)}
\usage{
create_ITSA(
  data,
  before_start = min(as.Date(data$Date, "\%m/\%d/\%Y")),
  before_end,
  after_start,
  after_end = max(as.Date(data$Date, "\%m/\%d/\%Y")),
  ac_lags_max = 7,
  return = "table"
)
}
\arguments{
\item{data}{Person Query as a dataframe including date column named \code{Date}.
This function assumes the data format is MM/DD/YYYY as is standard in a
Viva Insights query output.}

\item{before_start}{Start date of 'before' time period in MM/DD/YYYY format
as character type. Before time period is the period before the intervention
(e.g. training program, re-org, shift to remote work) occurs and bounded by
before_start and before_end parameters. Longer period increases likelihood
of achieving more statistically significant results. Defaults to earliest
date in dataset.}

\item{before_end}{End date of 'before' time period in MM/DD/YYYY  format as
character type.}

\item{after_start}{Start date of 'after' time period in MM/DD/YYYY  format as
character type. After time period is the period after the intervention
occurs and bounded by after_start and after_end parameters. Longer period
increases likelihood of achieving more statistically significant results.
Defaults to date after before_end.}

\item{after_end}{End date of 'after' time period in MM/DD/YYYY  format as
character type. Defaults to latest date in dataset.}

\item{ac_lags_max}{maximum lag for autocorrelation test. Default is 7}

\item{return}{String specifying what output to return. Defaults to "table".
Valid return options include:
\itemize{
\item \code{'plot'}: return a list of plots.
\item \code{'table'}: return data.frame with estimated models' coefficients and
their corresponding p-values You should look for significant p-values in
beta_2 to indicate an immediate treatment effect, and/or in beta_3 to
indicate a treatment effect over time
}}
}
\description{
r lifecycle::badge('experimental')

This function implements ITSA method described in the paper 'Conducting
interrupted time-series analysis for single- and multiple-group comparisons',
Ariel Linden, The Stata Journal (2015), 15, Number 2, pp. 480-500

This function further requires the installation of 'sandwich', 'portes', and
'lmtest' in order to work. These packages can be installed from CRAN using
\code{install.packages()}.
}
\details{
This function uses the additional package dependencies 'sandwich' and
'lmtest'. Please install these separately from CRAN prior to running the
function.

As of May 2022, the 'portes' package was archived from CRAN. The dependency
has since been removed and dependent functions \code{Ljungbox()} incorporated into
the \strong{wpa} package.
}
\examples{
\donttest{
# Returns summary table
create_ITSA(
  data = sq_data,
  before_start = "12/15/2019",
  before_end = "12/29/2019",
  after_start = "1/5/2020",
  after_end = "1/26/2020",
  ac_lags_max = 7,
  return = "table")

# Returns list of plots

plot_list <-
  create_ITSA(
    data = sq_data,
    before_start = "12/15/2019",
    before_end = "12/29/2019",
    after_start = "1/5/2020",
    after_end = "1/26/2020",
    ac_lags_max = 7,
    return = 'plot')

# Extract a plot as an example
plot_list$Workweek_span
}

}
\seealso{
Other Flexible Input: 
\code{\link{period_change}()}
}
\author{
Aleksey Ashikhmin \href{mailto:alashi@microsoft.com}{alashi@microsoft.com}
}
\concept{Flexible Input}
\concept{Interrupted Time-Series Analysis}
