# read in predictions generated by predict_boots()
test_preds <- readRDS("data/test_preds.rds")

test_that("summarise_predictions() returns predictions in expected format", {

  # read in data used to make predictions (new_data in predict_boots())
  test_test <- read.csv("data/test_test.csv")

  # generate summary
  x <- summarise_predictions(test_preds)

  # tests
  expect_s3_class(x, c("tbl_df", "tbl", "data.frame"))
  expect_named(x, c("rowid", ".preds", ".pred_lower", ".pred", ".pred_upper"))
  expect_type(x$.preds, "list")
  expect_type(x$.pred_lower, "double")
  expect_type(x$.pred, "double")
  expect_type(x$.pred_upper, "double")
  expect_type(x$.preds[[1]]$model, "character")
  expect_type(x$.preds[[1]]$model.pred, "double")
  expect_equal(nrow(x), nrow(test_test))

})

test_that("summarise_predictions() throws an error when passed bad data", {

  expect_error(
    summarise_predictions(test_preds[1]),
    "col `.preds` missing."
  )

  expect_error(
    summarise_predictions(dplyr::mutate(test_preds[1], .preds = 1)),
    "col `.preds` must be a list-col."
  )

  expect_error(
    summarise_predictions(dplyr::mutate(test_preds[1], .preds = list(tibble::tibble(model.pred = "model_1")))),
    "col `model.pred` must be numeric."
  )

})
