% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMongo.R
\name{mongo}
\alias{mongo}
\title{Fetch data from MongoDB to be stored in a data frame}
\usage{
mongo(
  collection_name,
  db_name = NULL,
  identifier = NULL,
  chunk_size = NULL,
  verbose = FALSE,
  interview_date = NULL
)
}
\arguments{
\item{collection_name}{The name of the MongoDB collection}

\item{db_name}{The database name (optional)}

\item{identifier}{Field to use as identifier (optional)}

\item{chunk_size}{Number of records per chunk (optional)}

\item{verbose}{Logical; if TRUE, displays detailed progress messages. Default is FALSE.}

\item{interview_date}{Optional; can be either:
- A date string in various formats (ISO, US, etc.) to filter data up to that date
- A boolean TRUE to return only rows with non-NA interview_date values}
}
\value{
A data frame containing the MongoDB data with superkeys first
}
\description{
Fetch data from MongoDB to be stored in a data frame
}
\examples{
\dontrun{
# Get data from MongoDB collection
data <- mongo("collection_name")
}
}
