% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_varinfo.R
\name{retrieve_varinfo}
\alias{retrieve_varinfo}
\title{Retrieves further information on a variable from GENESIS Databases}
\usage{
retrieve_varinfo(variablename, genesis = NULL, language = "de", ...)
}
\arguments{
\item{variablename}{name of the variable}

\item{genesis}{to authenticate a user and set the database (see below).}

\item{language}{retrieve information in German "de" (default) or in English "en" if available.}

\item{...}{other arguments send to the httr::GET request.}
}
\value{
a \code{data.frame}.
}
\description{
\code{retrieve_varinfo} retrieves further information.
}
\details{
See the package description (\code{\link{wiesbaden}}) for details about setting the login and database.
}
\examples{

 \dontrun{
 # Variable information 'AI2105' (Anteil der Empfänger von Arbeitslosengeld II im Alter 
 # von 15 bis 24 Jahren an der Bevölkerung gleichen Alters)
 # Assumes that user/password are stored via save_credentials()
 
 metadata <- retrieve_varinfo(variablename="AI2105", genesis=c(db="regio") )
 }




}
\seealso{
\code{\link{retrieve_datalist}} \code{\link{wiesbaden}}
}
