% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/widgetframe.R
\name{frameWidget}
\alias{frameWidget}
\title{A widget that wraps another widget inside a responsive iframe.}
\usage{
frameWidget(targetWidget, width = "100\%", height = NULL,
  elementId = NULL, options = frameOptions())
}
\arguments{
\item{targetWidget}{The widget to embed inside an iframe.}

\item{width}{Defaults to 100%. You can either specify '10%', '50%' etc. or
100, 200 (in pixel). This will override the width of the enclosed widget.}

\item{height}{Defaults to NULL. You can either specify '10%', '50%' etc. or
100, 200 (in pixel). This will override the height of the enclosed widget.}

\item{elementId}{The element ID of the parent widget.}

\item{options}{Options for the iframe.}
}
\description{
Uses \href{http://blog.apps.npr.org/pym.js/}{Pym.js}.
Pym.js embeds and resizes an iframe responsively (width and height) within
its parent container. It also bypasses the usual cross-domain issues.
}
\details{
This widget can be used in places where a HTML page's CSS rules or Javascript code
can cause issues in a widget. Wrapping your widgets this way allows for the widget
code to be unaffected by the parent HTML's CSS/JS. The target widget is
conveniently displaed in a responsive iframe and not subject to parent HTML's CSS/JS.
}
\examples{
\dontrun{
l <- leaflet() \%>\% addTiles() \%>\% setView(0,0,1)
frameWidget(l)
}

}
\seealso{
\code{\link{frameOptions}()}.
}
