% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wkt_centroid}
\alias{wkt_centroid}
\title{Extract Centroid}
\usage{
wkt_centroid(wkt)
}
\arguments{
\item{wkt}{a character vector of WKT objects, represented as strings}
}
\value{
a data.frame of two columns, \code{lat} and \code{lng},
with each row containing the centroid from the corresponding wkt
object. In the case that the object is NA (or cannot be decoded)
the resulting values will also be NA
}
\description{
\code{get_centroid} identifies the 2D centroid
in a WKT object (or vector of WKT objects). Note that it assumes
cartesian values.
}
\examples{
wkt_centroid("POLYGON((2 1.3,2.4 1.7))")
#  lng lat
#1 2   1.3
}
\seealso{
\code{\link{wkt_coords}} to extract all coordinates, and
\code{\link{wkt_bounding}} to extract a bounding box.
}
