# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

bounding_wkt_points <- function(min_x, max_x, min_y, max_y) {
    .Call('wicket_bounding_wkt_points', PACKAGE = 'wicket', min_x, max_x, min_y, max_y)
}

bounding_wkt_list <- function(x) {
    .Call('wicket_bounding_wkt_list', PACKAGE = 'wicket', x)
}

#'@title Extract Centroid
#'@description \code{get_centroid} identifies the 2D centroid
#'in a WKT object (or vector of WKT objects). Note that it assumes
#'cartesian values.
#'
#'@param wkt a character vector of WKT objects, represented as strings
#'
#'@return a data.frame of two columns, \code{lat} and \code{lng},
#'with each row containing the centroid from the corresponding wkt
#'object. In the case that the object is NA (or cannot be decoded)
#'the resulting values will also be NA
#'
#'@seealso \code{\link{wkt_coords}} to extract all coordinates, and
#'\code{\link{wkt_bounding}} to extract a bounding box.
#'
#'@examples
#'wkt_centroid("POLYGON((2 1.3,2.4 1.7))")
#'#  lng lat
#'#1 2   1.3
#'@export
wkt_centroid <- function(wkt) {
    .Call('wicket_wkt_centroid', PACKAGE = 'wicket', wkt)
}

sp_convert_ <- function(x, group) {
    .Call('wicket_sp_convert_', PACKAGE = 'wicket', x, group)
}

#'@title Validate WKT objects
#'@description \code{validate_wkt} takes a vector of WKT objects and validates that
#'they are parsable, returning a data.frame containing the status of each entry and
#'(in the case it cannot be parsed) any comments as to what, in particular, may be
#'wrong with it. It does not, unfortunately, check whether the object meets the WKT
#'spec - merely that it is formatted correctly.
#'
#'@param x a character vector of WKT objects.
#'
#'@return a data.frame of two columns, \code{is_valid} (containing TRUE or FALSE values
#'for whether the WKT object is parseable) and \code{comments} (containing any error messages
#'in the case that the WKT object cannot be parsed). If the objects are simply NA,
#'both fields will contain NA.
#'
#'@seealso \code{\link{sp_convert}} for generating valid WKT objects from SpatialPolygons
#'and SpatialPolygonDataFrames.
#'
#'@examples
#'wkt <- c("POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))",
#'         "ARGHLEFLARFDFG",
#'         "LINESTRING (30 10, 10 90, 40 out of cheese error redo universe from start)")
#'validate_wkt(wkt)
#'
#'@export
validate_wkt <- function(x) {
    .Call('wicket_validate_wkt', PACKAGE = 'wicket', x)
}

#'@title Convert WKT Objects into Bounding Boxes
#'@description \code{\link{wkt_bounding}} turns WKT objects
#'(specifically points, linestrings, polygons, and multi-points/linestrings/polygons)
#'into bounding boxes.
#'
#'@param wkt a character vector of WKT objects.
#'
#'@param as_matrix whether to return the results as a matrix (TRUE) or data.frame (FALSE). Set
#'to FALSE by default.
#'
#'@return either a data.frame or matrix, depending on the value of \code{as_matrix}, containing
#'four columns - \code{min_x}, \code{min_y}, \code{max_x} and \code{max_y} - representing the
#'various points of the bounding box. In the event that a valid bounding box cannot be generated
#'(due to the invalidity or incompatibility of the WKT object), NAs will be returned.
#'
#'@examples
#'wkt_bounding("POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))")
#'
#'@seealso \code{\link{bounding_wkt}}, to turn R-size bounding boxes into WKT objects.
#'
#'@export
wkt_bounding <- function(wkt, as_matrix = FALSE) {
    .Call('wicket_wkt_bounding', PACKAGE = 'wicket', wkt, as_matrix)
}

#'@title Extract Latitude and Longitude from WKT polygons
#'@description \code{wkt_coords} extracts lat/long values from WKT polygons,
#'specifically the outer shell of those polygons (working on the assumption that
#'said outer edge is what you want).
#'
#'Because it assumes \emph{coordinates}, it also assumes a sphere - say, the earth -
#'and uses spherical coordinate values.
#'
#'@param wkt a character vector of WKT objects
#'
#'@return a data.frame of four columns; \code{object} (containing which object
#'the row refers to), \code{ring} containing which layer of the object the row
#'refers to, \code{lng} and \code{lat}.
#'
#'@examples
#'wkt_coords("POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))")
#'# object  ring lng lat
#'# 1    1 outer  30  10
#'# 2    1 outer  40  40
#'# 3    1 outer  20  40
#'# 4    1 outer  10  20
#'# 5    1 outer  30  10
#'
#'@seealso \code{\link{wkt_bounding}} to extract a bounding box,
#'and \code{\link{wkt_centroid}} to extract the centroid.
#'@export
wkt_coords <- function(wkt) {
    .Call('wicket_wkt_coords', PACKAGE = 'wicket', wkt)
}

