% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_stochastic_depression_analysis}
\alias{wbt_stochastic_depression_analysis}
\title{Stochastic depression analysis}
\usage{
wbt_stochastic_depression_analysis(
  dem,
  output,
  rmse,
  range,
  iterations = 100,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output file.}

\item{rmse}{The DEM's root-mean-square-error (RMSE), in z units. This determines error magnitude.}

\item{range}{The error field's correlation length, in xy-units.}

\item{iterations}{The number of iterations.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a stochastic analysis of depressions within a DEM.
}
\keyword{HydrologicalAnalysis}
