% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis_analysis.R
\name{wbt_heat_map}
\alias{wbt_heat_map}
\title{Heat map}
\usage{
wbt_heat_map(
  input,
  output,
  weight_field = NULL,
  bandwidth = "",
  kernel = "quartic",
  cell_size = "",
  base = NULL,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input points shapefile.}

\item{output}{Name of the output raster image file.}

\item{weight_field}{Optional name of the attribute containing point weight.}

\item{bandwidth}{Bandwidth (metres).}

\item{kernel}{Kernel type; one of 'uniform', 'triangular', 'epanechnikov', 'quartic', 'triweight', 'tricube', 'gaussian', 'cosine', 'logistic', 'sigmoid', 'silverman'.}

\item{cell_size}{Optionally specified cell size of output raster, in metres. Not used when base raster is specified.}

\item{base}{Optionally specified input base raster file. Not used when a cell size is specified.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates a heat map, or kernel density estimation (KDE), for an input point set.
}
\keyword{GISAnalysis}
