% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_horizon_angle}
\alias{wbt_horizon_angle}
\title{Horizon angle}
\usage{
wbt_horizon_angle(
  dem,
  output,
  azimuth = 0,
  max_dist = 100,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{azimuth}{Azimuth, in degrees.}

\item{max_dist}{Optional maximum search distance (unspecified if none; in xy units). Minimum value is 5 x cell size.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates horizon angle (maximum upwind slope) for each grid cell in an input DEM.
}
