% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{drainage_preserving_smoothing}
\alias{drainage_preserving_smoothing}
\title{Drainage preserving smoothing}
\usage{
drainage_preserving_smoothing(dem, output, filter = 11, norm_diff = 15,
  num_iter = 10, max_diff = 2, reduction = 80, dfm = 0.15,
  zfactor = 1, verbose_mode = FALSE)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{output}{Output raster file.}

\item{filter}{Size of the filter kernel.}

\item{norm_diff}{Maximum difference in normal vectors, in degrees.}

\item{num_iter}{Number of iterations.}

\item{max_diff}{Maximum allowable absolute elevation change (optional).}

\item{reduction}{Maximum Amount to reduce the threshold angle by (0 = full smoothing; 100 = no smoothing).}

\item{dfm}{Difference from median threshold (in z-units), determines when a location is low-lying.}

\item{zfactor}{Optional multiplier for when the vertical and horizontal units are not the same.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}
}
\value{
Returns the tool text outputs.
}
\description{
Reduces short-scale variation in an input DEM while preserving breaks-in-slope and small drainage features using a modified Sun et al. (2007) algorithm.
}
