% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counter.R
\name{counter_state}
\alias{counter_state}
\alias{counter_reset}
\alias{counter_names}
\title{whereami counter}
\usage{
counter_state(item = NULL)

counter_reset(item = NULL)

counter_names()
}
\arguments{
\item{item}{character, name of the counter to access, Default: NULL}
}
\description{
Interact with internal whereami counter
}
\details{
counter_names returns names of the active stored counters.

counter_state returns current hit count for item, if NULL then all counters
are returned.

counter_reset will remove counter of item, if item is NULL then all counters
are reset.
}
\examples{

if( interactive() ){

tf <- tempfile(fileext = '.R')

# call to write to temp file
f <- 'whereami::cat_where(whereami::whereami())'

# write to the file (call at line 3)
cat('\\n\\n',f,sep='',file = tf)

source(tf)

counter_state()

counter_names()

# using counter_reset and counter_names in a loop

for( i in 1:10 ){

  source(tf)

  if( counter_state(counter_names()[1]) > 5 )
    counter_reset(counter_names()[1])
}

# clear all counters
counter_reset()

# cleanup
unlink(tf)

}

}
\author{
Jonathan Sidi
}
\concept{counter}
