% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readers.R
\name{read_combined}
\alias{read_combined}
\title{read Combined Log Format files}
\usage{
read_combined(file, has_header = FALSE)
}
\arguments{
\item{file}{the full path to the CLF-formatted file you want to read.}

\item{has_header}{whether or not the file has a header row. Set to FALSE by
default.}
}
\description{
read requests logs following the Combined Log Format.
}
\details{
the Combined Log Format (CLF) is the same as the Common Log Format (CLF, because
software engineers and naming go together like chalk and cheese), which
is documented at \code{\link{read_clf}}. In addition to the fields described there,
the Combined Log Format also includes:

\itemize{
 \item{referer:} {the referer associated with the request.}
 \item{user_agent:} {the user agent of the user that made the request.}
}

\code{read_combined} handles these fields, as well as the CLF-standard ones. This is (amongst
other things) the default logging format for \href{http://nginx.org/}{nginx} servers
}
\examples{
#Read in an example Combined-formatted file provided with the webreadr package.
data <- read_combined(system.file("extdata/combined_log.clf", package = "webreadr"))
}
\seealso{
\code{\link{read_clf}} for the /Common/ Log Format, and
\code{\link{split_clf}} for splitting out the "requests" field.
}

