% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loop.R
\name{loop}
\alias{loop}
\title{Loop}
\usage{
loop(stimuli, steps = 10, ...)
}
\arguments{
\item{stimuli}{list of stimuli to morph between}

\item{steps}{number of steps from one image to the next}

\item{...}{arguments to pass to \code{\link[=trans]{trans()}}}
}
\value{
list of stimuli containing each step of the loop
}
\description{
Morph between each image in a list of stimuli, looping back to the start.
}
\examples{
\donttest{
if (webmorph_up()) {
  # align and crop images
  stimuli <- demo_unstandard(1:5) |> 
    align() |> crop_tem()
  
  loop <- loop(stimuli, 5)
  
  # create an animated gif
  animate(loop, fps = 10)
}
}
}
\seealso{
WebMorph.org functions
\code{\link{avg}()},
\code{\link{continuum}()},
\code{\link{symmetrize}()},
\code{\link{trans}()},
\code{\link{webmorph_up}()}
}
\concept{webmorph}
