% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cts.R
\name{cts_convert}
\alias{cts_convert}
\title{Convert Ids using Chemical Translation Service (CTS)}
\usage{
cts_convert(
  query,
  from,
  to,
  match = c("all", "first", "ask", "na"),
  verbose = getOption("verbose"),
  choices = NULL,
  ...
)
}
\arguments{
\item{query}{character; query ID.}

\item{from}{character; type of query ID, e.g. \code{'Chemical Name'} ,
\code{'InChIKey'}, \code{'PubChem CID'}, \code{'ChemSpider'}, \code{'CAS'}.}

\item{to}{character; type to convert to.}

\item{match}{character; How should multiple hits be handled? \code{"all"}
returns all matches, \code{"first"} returns only the first result,
\code{"ask"} enters an interactive mode and the user is asked for input,
\code{"na"} returns \code{NA} if multiple hits are found.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{choices}{deprecated.  Use the \code{match} argument instead.}

\item{...}{currently not used.}
}
\value{
a list of character vectors or if \code{choices} is used, then a
single named vector.
}
\description{
Convert Ids using Chemical Translation Service (CTS), see
\url{http://cts.fiehnlab.ucdavis.edu/}
}
\details{
See also \url{http://cts.fiehnlab.ucdavis.edu/}
for possible values of from and to.
}
\note{
When this version of webchem was released, CTS was temporarily unable
to convert chemical names to IDs.
}
\examples{
\donttest{
# might fail if API is not available
cts_convert("XEFQLINVKFYRCS-UHFFFAOYSA-N", "inchikey", "Chemical Name")

### multiple inputs
keys <- c("XEFQLINVKFYRCS-UHFFFAOYSA-N", "VLKZOEOYAKHREP-UHFFFAOYSA-N")
cts_convert(keys, "inchikey", "cas")
}
}
\references{
Wohlgemuth, G., P. K. Haldiya, E. Willighagen, T. Kind, and O.
Fiehn 2010The Chemical Translation Service -- a Web-Based Tool to Improve
Standardization of Metabolomic Reports. Bioinformatics 26(20): 2647–2648.
}
\seealso{
\code{\link{cts_from}} for possible values in the 'from' argument
and \code{\link{cts_to}} for possible values in the 'to' argument.
}
