% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pan.R
\name{pan_query}
\alias{pan_query}
\title{Query the PAN Pesticide database}
\usage{
pan_query(query, match = c("best", "all", "first"), verbose = TRUE, ...)
}
\arguments{
\item{query}{character; searchterm, e.g. chemical name or CAS.}

\item{match}{character; \code{match="all"} returns all matches,
\code{match="first"} the first one and \code{match="best"} (recommended) the hit with the lowest
 Levenshtein distance between query and matching synonym.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a named list of 73 entries,
  see \url{http://www.pesticideinfo.org/Docs/ref_overview.html} for more information.
  If \code{match="best"} an additional entry \code{match_score} with the normalized
  Levenshtein distance (0 = perfect match, 1 = worst match).

CAS Number; U.S. EPAPC Code; CA ChemCode;
Use Type; Chemical Class; Molecular Weight; U.S. EPARegistered ; CA Reg Status;
PIC; POPs; WHO Obsolete; EPA HAP; CA TAC; Ground Water Contaminant;
CA Grnd Water Contam.; Acute Aquatic Toxcity; Chronic Aquatic Toxicity;
PAN BadActor Chem; Dirty Dozen; Acute Toxicity Summary; Cholinesterase Inhibitor;
Acute rating from U.S. EPA product label; U.S. NTP Acute Toxicity Studies;
Material Safety Data Sheets; TRI Acute Hazard; WHO Acute Toxicity; Cancer Rating;
U.S. EPA Carcinogens; IARC Carcinogens; U.S. NTP Carcinogens;
California Prop 65 Known Carcinogens; TRI Carcinogen;
Developmental or Reproductive Toxicity; CA Prop 65 Developmental Toxin;
U.S. TRI Developmental Toxin; CA Prop 65 Female Reproductive Toxin;
CA Prop 65 Male Reproductive Toxin ; U.S. TRI Reproductive Toxin;
Endocrine Disruption; E.U. ED Rating; Benbrook list; Denmark Inert list;
Colborn list; Illinois EPA list; Keith list; Water Solubility (Avg, mg/L);
Adsorption Coefficient (Koc); Hydrolysis Half-life (Avg, Days);
Aerobic Soil Half-life (Avg, Days); Anaerobic Soil Half-life (Avg, Days);
Maximum Contaminant Level (MCL) (ug/L); Maximum Contaminant Level Goal (MCLG) (ug/L);
One Day Exposure Health Advisory Level (ug/L); Ten Day Exposure Health Advisory Level (ug/L);
Reference Dose (ug/kg/day); U.S. Drinking Water Equivalent Level (ug/L);
Lifetime Exposure Health Advisory Level (ug/L);
Lifetime Estimated Cancer Risk (cases per 1,000,000);
Maximum Acceptable Concentration (MAC) (ug/L);
Interim Maximum Acceptable Concentration (IMAC) (ug/L);
Aesthetic Objectives (ug/L); Fresh Water Quality Criteria Continuous Exposure (ug/L);
Fresh Water Quality Criteria Maximum Peak (ug/L); Salt Water Quality Criteria Continuous Exposure (ug/L);
Salt Water Quality Criteria Max (ug/L); Human Consumption of Organisms from Water Source (ug/L);
Human Consumption of Water and Organisms from Water Source (ug/L);
Taste and Odor Criteria (ug/L);
Fresh Water Guidelines (ug/L); Salt Water Guidelines (ug/L);
Irrigation Water Guidelines (ug/L); Livestock Water Guidelines (ug/L);
Chemical Name; matching synonym; source URL
}
\description{
Retrieve information from the PAN database (\url{http://www.pesticideinfo.org/})
}
\examples{
\dontrun{
 # might fail if API is not available

 # return all hits
 pan_query('2,4-dichlorophenol')[[1]][c(1, 2, 5, 74)]
 # return only first hit
 pan_query('2,4-dichlorophenol', match = 'first')[[1]][c(1, 2, 5, 74)]
 # return only best hit
 pan_query('2,4-dichlorophenol', match = 'best')[[1]][c(1, 2, 5, 74)]

 out <- pan_query(c('Triclosan', 'Aspirin'), 'best')
 out

 # extract Hydrolysis Half-life (Avg, Days)
 sapply(out, function(y) y$`Hydrolysis Half-life (Avg, Days)`)
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

