% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/alanwood.R
\name{alanwood}
\alias{alanwood}
\title{Query http://www.alanwood.net/pesticides}
\usage{
alanwood(x, type = c("commonname", "cas"), verbose = TRUE)
}
\arguments{
\item{x}{character; search string}

\item{type}{character; type of input}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A list of eight entries: common-name, status, preferredd IUPAC Name,
         IUPAC Name, cas, formula, activity, inchikey, inchi
}
\description{
Query Alan Woods Compendium of Pesticide Common Names http://www.alanwood.net/pesticides
}
\note{
for type = 'cas' only the first link is returned
}
\examples{
\dontrun{
alanwood('Fluazinam', type = 'commonname')
sapply(c('Fluazinam', 'Diclofop', 'xxxxx'), alanwood, type = 'com')
alanwood("79622-59-6", type = 'cas')
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

