% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cts.R
\name{cts_convert}
\alias{cts_convert}
\title{Convert Ids using Chemical Translation Service (CTS)}
\usage{
cts_convert(query, from, to, first = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{query}{character; query ID.}

\item{from}{character; type of query ID, e.g. \code{'Chemical Name'} , \code{'InChIKey'},
\code{'PubChem CID'}, \code{'ChemSpider'}, \code{'CAS'}.}

\item{to}{character; type to convert to.}

\item{first}{logical; return only first result be returned?}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a character vector.
}
\description{
Convert Ids using Chemical Translation Service (CTS), see \url{http://cts.fiehnlab.ucdavis.edu/conversion/index}
}
\examples{
\donttest{
# might fail if API is not available
cts_convert('XEFQLINVKFYRCS-UHFFFAOYSA-N', 'inchikey', 'Chemical Name')
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

