% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layer_functions.R
\name{get_wis_raster_layer}
\alias{get_wis_raster_layer}
\alias{get_wis_landcover}
\alias{get_wis_imagery}
\title{Get WDNR Image and Map Layers}
\usage{
get_wis_landcover(
  service = "EN_Land_Cover2_Lev2",
  county = NULL,
  watershed_code = NULL,
  watershed_name = NULL,
  sf_object = NULL,
  ...
)

get_wis_imagery(
  service = "EN_Image_Basemap_Leaf_Off",
  county = NULL,
  watershed_code = NULL,
  watershed_name = NULL,
  sf_object = NULL,
  ...
)
}
\arguments{
\item{service}{A string describing the service to be pulled.}

\item{county}{A character object specifying a county name}

\item{watershed_code}{A character object specifying the HUC code for a
watershed}

\item{watershed_name}{A character object specifying the HUC name for a
watershed}

\item{sf_object}{Any sf polygon object}

\item{...}{Additional arguments to be passed to \code{\link{get_map_layer}}}
}
\value{
A "RasterLayer" object
}
\description{
Functions to pull layers from the ImageServer and MapServer sections of the
\href{https://dnrmaps.wi.gov/arcgis_image/rest/services}{
  Wisconsin Department of Natural Resources ArcGIS REST API
}. These are raster layers representing various maps and images throughout
the state of Wisconsin. Arguments to these function can be used to specify
the spatial extent of the output. If no argument is provided, the full
raster will be queried.
}
\details{
For a full list of available services use the following search options.
\itemize{
  \item{
    get_wis_landcover
  }{
    -- \code{list_services(section = "DW_Land_Cover")}
  }
  \item{
    get_wis_imagery
  }{
    -- \code{list_services(section = "DW_Image")}
  }
}
}
\examples{
\dontrun{
mke_forest <- get_wis_landcover(county = c("Milwaukee","Forest"))
plot_layer(mke_forest, outline_poly = wi_poly, legend = FALSE)


}
}
