% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dprewire_directed_cpp}
\alias{dprewire_directed_cpp}
\title{Degree preserving rewiring process for directed networks.}
\usage{
dprewire_directed_cpp(
  iteration,
  nattempts,
  targetNode,
  sourceOut,
  sourceIn,
  targetOut,
  targetIn,
  index_s,
  index_t,
  eta,
  rewire_history
)
}
\arguments{
\item{iteration}{Integer, number of iterations of nattempts rewiring attempts.}

\item{nattempts}{Integer, number of rewiring attempts per iteration.}

\item{targetNode}{Vector, target node sequence - 1.}

\item{sourceOut}{Vector, source nodes' out-degree.}

\item{sourceIn}{Vector, source nodes' in-degree.}

\item{targetOut}{Vector, target nodes' out-degree.}

\item{targetIn}{Vector, target nodes' in-degree.}

\item{index_s}{Index of source nodes' out- and in-degree. 
index_s/index_t bridges the indices of source/target nodes and the 
target structure eta.}

\item{index_t}{Index of target nodes' out- and in-degree.}

\item{eta}{Matrix, target structure eta generated by
\code{wdnet::get_eta_directed()}.}

\item{rewire_history}{Logical, whether the rewiring history should be returned.}
}
\value{
Target node sequence, four directed assortativity coefficients after
  each iteration, and rewire history.
}
\description{
Degree preserving rewiring process for directed networks.
}
\keyword{internal}
