% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/querxc.R
\name{querxc}
\alias{querxc}
\title{Access Xeno-Canto recordings and metadata}
\usage{
querxc(qword, download = FALSE, X = NULL)
}
\arguments{
\item{qword}{Character vector of length one indicating the genus, or genus and
species, to query Xeno-Canto database. For example, \emph{Phaethornis} or \emph{Phaethornis longirostris}.
(\url{http://www.xeno-canto.org/}).}

\item{download}{Logical argument. Downloads recording file names and
associated metadata if \code{FALSE}. If \code{TRUE}, recordings are also downloaded to working
directory as .mp3 files. Default is \code{FALSE}.}

\item{X}{data frame with the same columns as the output of the function, or at least the following
columns: Genus, Specific_epithet and Recording_ID. Only the recordings listed in the data frame
will be download (\code{download} argument isautomatically set to \code{TRUE}). This can be used to select
the recordings to be downloaded based on their attributes.}
}
\value{
A data frame with recording information is returned if X is not provided. Sound files in .mp3 format
(if download = \code{TRUE} or if X is provided).
}
\description{
\code{querxc} downloads recordings and metadata from Xeno-Canto (\url{http://www.xeno-canto.org/}).
}
\examples{
\dontrun{
# First create empty folder
dir.create(file.path(getwd(),"temp"))
setwd(file.path(getwd(),"temp"))
df1 <- querxc("Phaethornis anthophilus", download = FALSE)
View(df1)

#downloading files
querxc("Phaethornis anthophilus", download = TRUE)
#check this folder!!
getwd()

# remove example directory
unlink(getwd(),recursive = TRUE)
}
}
\author{
Marcelo Araya-Salas (\url{http://marceloarayasalas.weebly.com/}) and Hua Zhong
}

