% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_point.R
\name{start_point}
\alias{start_point}
\title{start point}
\usage{
start_point(A, b, n = 1, average = 10)
}
\arguments{
\item{A}{is the lhs of \eqn{Ax \le b}}

\item{b}{is the rhs of \eqn{Ax \le b}}

\item{n}{is the number of points we want to return}

\item{average}{is the number of boundary points we want to take the average
of}
}
\value{
a matrix, with each column as a point
}
\description{
Given \eqn{Ax \le b}, which defines a convex
polytope, this function picks n random
starting "center" points using linear programming.
}
\examples{

A <- rbind(c(-1, 0), c(0, -1), c(1, 1))
b <- c(0, 0, 1)
start_point(A = A, b = b, n = 1, average = 10) 
}
