% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grVizToPNG.R
\name{grVizToPNG}
\alias{grVizToPNG}
\title{grVizToPNG}
\usage{
grVizToPNG(g, width = NULL, height = NULL, folder = ".", filename)
}
\arguments{
\item{g}{an object produced by the grViz function from the DiagrammmeR package}

\item{width}{the width in pixels of the bitmap}

\item{height}{the height in pixels of the bitmap}

\item{folder}{path to folder where the PNG file should stored}

\item{filename}{an optional filename.
If not provided, the filename will be derived from the name 
of the argument of \code{g}.}
}
\value{
Returns the full path of the PNG file.
}
\description{
\code{grVizToPNG} Export a grViz object into a PNG file.
}
\details{
First the grViz object is exported to an SVG file (using \code{DiagrammeRsvg::export_svg}).
  Then the SVG file is converted to a bitmap (using \code{rsvg::rsvg}).
  Then the bitmap is exported as a PNG file (using \code{png::writePNG}).
  Note that the SVG file and the PNG file will be named using the name of the \code{g} parameter
}
\note{
In addition to the DiagrammmeR package, the following packages are used: \code{DiagrammeRsvg}, \code{rsvg}
}
\author{
Nick Barrowman
}
