% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/scanonevar.R
\name{scanonevar}
\alias{scanonevar}
\title{Conduct a scanonevar.}
\usage{
scanonevar(cross, mean.formula, var.formula, return.effects = FALSE,
  return.effect.ses = FALSE, return.effect.ps = FALSE,
  chrs = unique(names(cross$geno)), exclusion.window = 0.8,
  family = stats::gaussian)
}
\arguments{
\item{cross}{The cross on which the scanonevar will be conducted.}

\item{mean.formula}{The formula that describes the response, and the covariates and genetic effects that influence it.
  The left hand side of the ~ must be a single phenotype that is in the cross.
  The right hand side must use only phenotypes thata are in the cross, markers that are in the cross,
  and the special terms: mean.QTL.add (additive effect on the mean) and mean.QTL.dom (dominance deviation from additive on the mean).}

\item{var.formula}{The formula that describes the covariates and the genetic effects that influence residual (environmental) variation.
  There should be nothing on the left of the ~ (Inferred to be residual variation).
  The right hand side must use only phenotypes thata are in the cross, markers that are in the cross,
  and the special terms: var.QTL.add (additive effect on the variance) and var.QTL.dom (dominance deviation from additive on the variance).}

\item{return.effects}{Logical indicating whether the estimated effects should be returned.}

\item{return.effect.ses}{Logical indicating whether the standard errors of the estimated effects should be returned.}

\item{return.effect.ps}{Logical indicating whether the p-value of the estimated effects should be returned.}

\item{chrs}{The subset of chromosomes to scan (defaults to all chromosomes).}

\item{exclusion.window}{Numeric between 0 and 1 indicating how tightly a locus must be correlated with a covariate to be skipped.
  e.g. if cor.threshold is 0.8 (it's default) any locus with \code{cor(locus, covariate) > 0.8} will be skipped.}

\item{family}{Family of distribution to be modeled.  Defaults to 'gaussian'.
   See dglm and glm documentation for other options.  Most notable other options is 'poisson'}
}
\value{
A scanonevar object.
}
\description{
\code{scanonevar} conducts a scanonevar, a genome scan that takes into account
   genetic and non-genetic effects on residual (environmental) variation in the trait of interest.
}
\details{


none
}
\examples{
my.cross <- sim.cross(map = sim.map(), type = 'f2')
   my.cross$pheno$sex <- rbinom(n = 100, size = 1, prob = 0.5)
   my.cross <- calc.genoprob(my.cross)

   scanonevar(cross = my.cross,
              mean.formula = 'phenotype ~ sex + mean.QTL.add + mean.QTL.dom',
              var.formula = '~sex + var.QTL.add + var.QTL.dom',
              chrs = 1:3)
}
\author{
Robert Corty \email{rcorty@gmail.com}
}

