% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/scan.via.dglm.R
\name{scan.via.dglm}
\alias{scan.via.dglm}
\title{Conduct a Scanonevar Using the DGLM Function}
\usage{
scan.via.dglm(mean.alt.formula, var.alt.formula, genoprobs, mapping.df,
  chr.by.marker, pos.by.marker, marker.names, return.effects = FALSE,
  return.effect.ses = FALSE, return.effect.ps = FALSE,
  cor.threshold = 0.8, perm = 1:nrow(genoprobs), family = "gaussian")
}
\arguments{
\item{mean.alt.formula}{The formula for the trait mean in the alternative model.
  \code{mean.null.formula} and \code{test.mean.effect} are inferred from it.}

\item{var.alt.formula}{The formula for the trait variance in the alternative model.
  \code{var.null.formula} and \code{test.var.effect} are inferred from it.}

\item{genoprobs}{The probability of each genotype for each individual.}

\item{mapping.df}{The tbl_df with the response, all covariates, and space for the focal genotype.}

\item{chr.by.marker}{a vector of the chromosome name of each marker}

\item{pos.by.marker}{a vector of the position of each marker}

\item{marker.names}{a vector of the name of each marker}

\item{return.effects}{Logical indicating whether the estimated effects should be returned.}

\item{return.effect.ses}{Logical indicating whether the standard errors of the estimated effects should be returned.}

\item{return.effect.ps}{Logical indicating whether the p-value of the estimated effects should be returned.}

\item{cor.threshold}{Numeric between 0 and 1 indicating how tightly a locus must be correlated with a covariate to be skipped.
  e.g. if cor.threshold is 0.8 (it's default) any locus with \code{cor(locus, covariate) > 0.8} will be skipped.}

\item{perm}{The permutation to apply to the genotypes.  Defaults to identity permutation.}

\item{family}{Family of distribution to be modeled.  Defaults to 'gaussian'.
   See dglm and glm documentation for other options.  Most notable other options is 'poisson'}
}
\value{
Returns a scanonevar object.
}
\description{
\code{scan.via.dglm} should not typically be called by a user.
 This function is used by both \code{scanonevar} and \code{scanonevar.perm}.
 This function is not typically necessary for a typical user.
}
\details{


none
}
\author{
Robert Corty \email{rcorty@gmail.com}
}
\seealso{
\code{\link{scanonevar}}, \code{\link{scanonevar.perm}}
}

