% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rlrt4d.R
\name{plot.rlrt4d}
\alias{plot.rlrt4d}
\title{Display cross-sections of voxelwise RLRT results}
\usage{
\method{plot}{rlrt4d}(x, array4d, disp = c("stat", "p", "fdr", "pwdf"),
  titl = NULL, slices = NULL, colbar = TRUE,
  col.image = shape::femmecol(100)[100:1], neglog10 = FALSE,
  threshold = NULL, mar = c(2, 2, 2, 2), digit = 2, nrow = NULL, ...)
}
\arguments{
\item{x}{a voxelwise RLRT object as produced by \code{\link{rlrt4d}}.}

\item{array4d}{the 4D array on which the voxelwise RLRT was performed.}

\item{disp}{values from the RLRT object to be displayed: either RLRT
statistics, p-values, or FDR values.}

\item{titl}{title of the panel.}

\item{slices}{indices of the slice(s) to be displayed.}

\item{colbar}{logical: Should a color bar be included?}

\item{col.image}{color scheme for the color bar, as generated by
\code{\link{rainbow}}, \code{\link{heat.colors}}, etc.}

\item{neglog10}{logical; if \code{TRUE}, negative base \code{10} logarithm
(of the quantity specified by \code{disp}) is displayed.}

\item{threshold}{the upper limit of the values to be plotted. All larger
values will be replaced by the threshold value.}

\item{mar}{A numerical vector of the form c(bottom, left, top, right)
specifying the number of lines of margin on the four sides of the plot.}

\item{digit}{number of significant digits in labels.}

\item{nrow}{number of rows on the plot.}

\item{\dots}{arguments passed to \code{\link[graphics]{plot}.}}
}
\description{
Plots slices of the 3D array representing a set of voxelwise RLRT results.
}
\examples{

# Please see the example for rlrt4d
}
\author{
Lei Huang \email{huangracer@gmail.com}, Philip Reiss
\email{phil.reiss@nyumc.org} and Lan Huo
}
\seealso{
\code{\link{rlrt4d}}
}

