% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddUserData.R
\name{vosonSML::AddUserData.actor.twitter}
\alias{vosonSML::AddUserData.actor.twitter}
\alias{AddUserData.actor.twitter}
\title{Supplement twitter actor network by adding user profile attributes to nodes}
\usage{
\method{AddUserData}{actor.twitter}(
  net,
  data,
  lookupUsers = TRUE,
  twitterAuth = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{net}{A named list of dataframes \code{nodes} and \code{edges} generated by \code{Create}.}

\item{data}{A dataframe generated by \code{Collect}.}

\item{lookupUsers}{Logical. Lookup user profile information using the twitter API for any users data missing from 
the collect data set. For example fetches profile information for users that became nodes during network creation 
because they were mentioned in a tweet but did not author any tweets themselves. Default is \code{TRUE}.}

\item{twitterAuth}{A twitter authentication object from \code{Authenticate}.}

\item{verbose}{Logical. Output additional information about the network creation. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes}, \code{$edges} and
\code{$users}. Nodes include columns for additional user data.
}
\description{
Network is supplemented with additional downloaded user information applied as actor node attributes.
}
\note{
Using the standard twitter API this function is limited to collecting profiles of 90000 users per 15 mins
before hitting the rate limit. It does not wait and retry upon hitting rate limit.
}
\examples{
\dontrun{
# add user info to a twitter actor network
actorNetwork <- collectData \%>\%
  Create("actor") \%>\% AddUserData(collectData, twitterAuth = myTwitterAuth)

# network
# actorNetwork$nodes
# actorNetwork$edges
}

}
