% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Authenticate.twitter.R
\name{Authenticate.twitter}
\alias{Authenticate.twitter}
\title{Twitter API authentication}
\usage{
\method{Authenticate}{twitter}(socialmedia, appName, apiKey, apiSecret,
  accessToken, accessTokenSecret, useCachedToken = TRUE, ...)
}
\arguments{
\item{socialmedia}{Character string. Identifier for social media API to authenticate, set to \code{"twitter"}.}

\item{appName}{Character string. Registered twitter app name associated with the API keys.}

\item{apiKey}{Character string. API key to authenticate.}

\item{apiSecret}{Character string. API secret to authenticate.}

\item{accessToken}{Character string. API access token to authenticate.}

\item{accessTokenSecret}{Character string. API access token secret to authenticate.}

\item{useCachedToken}{Logical. Use cached access token if found otherwise create one. The cached token file is 
named \code{.twitter-oauth} and saved to the working directory.To refresh the cached token this file has to be 
manually deleted. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
A \code{credential} object containing an access token \code{$auth} and social media type descriptor 
\code{$socialmedia} set to \code{"twitter"}. Object has the class names \code{"credential"} and \code{"twitter"}.
}
\description{
Twitter authentication uses OAuth and requires Application-user authentication API keys as described here: 
\url{https://developer.twitter.com/en/docs/basics/authentication/overview/oauth}.
}
\examples{
\dontrun{
# twitter authentication with api keys
myKeys <- list(appName = "vosonSML", apiKey = "xxxxxxxxxxxx",
  apiSecret = "xxxxxxxxxxxx", accessToken = "xxxxxxxxxxxx",
  accessTokenSecret = "xxxxxxxxxxxx")

twitterAuth <- Authenticate("twitter", appName = myKeys$appName, 
  apiKey = myKeys$apiKey, apiSecret = myKeys$apiSecret, accessToken = myKeys$accessToken, 
  accessTokenSecret = myKeys$accessTokenSecret, useCachedToken = TRUE)
}

}
