% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{collate_yr}
\alias{collate_yr}
\title{Collate Vortex .yr output files}
\usage{
collate_yr(
  project,
  scenario,
  npops_noMeta = 1,
  dir_in = NULL,
  save2disk = TRUE,
  dir_out = "ProcessedData",
  verbose = TRUE
)
}
\arguments{
\item{project}{The Vortex project name to be imported}

\item{scenario}{The scenario name, default: NULL}

\item{npops_noMeta}{The total number of populations excluding the
metapopulation, default: 1}

\item{dir_in}{The local folder containing Vortex files, default: NULL. If
not specified, will fall back to use current working directory.}

\item{save2disk}{Whether to save the data as rda and csv, default: TRUE}

\item{dir_out}{The local path to store the output. Default: ProcessedData}

\item{verbose}{Progress messages, default: TRUE}
}
\value{
a list with two elements: 'census', a data.frame with data from all
Vortex files and 'census_means', a data.table with the mean of each parameter
across all iterations for each simulated year
}
\description{
\code{collate_yr} collates all the .yr output from Vortex matching the
project and scenario name into one R object and calculates the mean for each
simulated year across all iterations.
}
\details{
\code{dir_in} may contain other files; only files matching the project and
the scenario name will be read.

\code{dir_out} is created within the working directory unless a full path is
provided.

If no matching files are found in the given directory, an error is reported.

When \code{verbose=TRUE} the progress (i.e. the file being read) is reported
on screen.
}
\examples{
# Using Pacioni et al. example files. See ?pacioni for more details.
pac.dir <- system.file('extdata', 'pacioni', package='vortexRdata')

# Run collate_yr on all .yr of project 'Pacioni_et_al' and the ST scenario
# 'ST_Classic' in the selected folder and store the result in 'yr.st.classic'
yr.st.classic <- collate_yr(project='Pacioni_et_al', scenario='ST_Classic',
                            dir_in = pac.dir, save2disk=FALSE)
}
